// Version/Precision tags are added programmatically on shader load

#define MAX_BONES %

attribute vec3 vPosition;
attribute float vaWeight1;
attribute float vaWeight2;

uniform mat4 mProj;
uniform mat4 mView;
uniform mat4 mModel;
uniform mat4 mBones[MAX_BONES];

void main()
{
  int bone1 = int(vaWeight1);
  int bone2 = int(vaWeight2);

  // Multiplied with 0.9 in code to avoid rounding Id up to next bone
  float bone1w = fract(vaWeight1) / 0.9;
  float bone2w = fract(vaWeight2) / 0.9;

  vec4 vert = vec4(vPosition, 1.0) * mBones[bone1] * bone1w +
              vec4(vPosition, 1.0) * mBones[bone2] * bone2w;
  vert.w = 1.0;

  gl_Position = mProj * mView * mModel * vert;
}